<!DOCTYPE html>

<?php

/* * ***************************************************************************
 * PHP 3 : accesBDD.php
 * Regroupement de toutes les fonctions d'accès à la base de données
 * ************************************************************************** */
define("DEBUG_SQL", "debug-sql");       // nom du fichier de log

/**
 * Connexion persistante au serveur
 * @return \PDO Connexion
 */
function connexion() {
    // Définition des variables de connexion
    $user = "root";
    $pass = "root";
    $dsn = 'mysql:host=localhost;dbname=gsbbdcr'; //Data Source Name
    // Connexion
    try {
        $dbh = new PDO($dsn, $user, $pass, array(
            PDO::ATTR_PERSISTENT => true, // Connexion persistante
            PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES \'UTF8\''));
    } catch (PDOException $e) {
        erreurSQL($e->getMessage(), "Pb connexion", $dbh);
    }
    return $dbh;
}

/**
 * Recherche si le login existe déjà
 * @param type $dbh         Connexion
 * @param type $login       pseudo à vérifier
 * @return type             booléen, true si le login existe
 */
function existLogin($dbh, $login) {
    $sql = "SELECT COUNT(*) FROM utilisateur WHERE login = '$login';";
    $resultat = $dbh->query($sql);       // Execution de la requete
    if ($resultat === false) {
        erreurSQL("Pb lors de la recherche du login.", $sql, $dbh);
    }
    $count = $resultat->fetchColumn();  // Retourne la valeur de la 1ère col de la ligne suivante (param 0 par défaut)
    return ($count > 0);
}

/** afficherErreurSQL :
 *  Ajout message d'erreur dans le fichier log, fin de l'application
 *  @param $message	: message a afficher
 *  @param $req 	: requete executee
 *  @param $dbh         : connexion PDO
 */
function erreurSQL($message, $req, $dbh) {
    error_log("\n***Erreur SQL*** " . date('Y-m-d H-i-s') . "\tAdresse IP : " . getIp(), 3, DEBUG_SQL);
    error_log("\n\tMessage: " . $message, 3, DEBUG_SQL);
    error_log("\n\tRequete: " . $req, 3, DEBUG_SQL);
    if ($dbh) {
        //$erreur = print_r($dbh->errorInfo(), true);
        $erreur = $dbh->errorInfo()[2];
        error_log("\n\tErreur: " . $erreur, 3, DEBUG_SQL);
    }
    //echo("Taille log : " . stat(DEBUG_SQL)[7]);
    //echo(" - Date dernière modif : " . date("d m Y H:i:s.", filemtime(DEBUG_SQL)));

	//changement PHP3, ligne suivante à commenter
	//die("<p id='erreur1'>Désolé, site actuellement indisponible </p>");
}

/**
 * Recherche de l'utilisateur selon login et mot de passe
 * @param type $dbh
 * @param type $login
 * @param type $mdp
 * @return type utilisateur trouvé ou false sinon;
 */

function rechercherUtilisateur($dbh, $login, $mdp) {
	$sql = "SELECT * FROM utilisateur WHERE uLogin = '$login' AND uMDP = SHA2('$mdp',256);";

    $resultat = $dbh->query($sql);       // Execution de la requete
    if ($resultat === false) {
        erreurSQL("Pb lors de la recherche de l'utilisateur.", $sql, $dbh);
		return false;
    }
    $laLigne=$resultat->fetch();
    return $laLigne;
}

/**
 * Recherche de tous les clients
 * @param type $dbh
 * @return type jeu d'enregistrements
 */
function rechercherLesPraticiens($dbh,$regionUtilisateur) {
    $sql = "SELECT *,parametre.pLibelle as pRegion 
            FROM praticien 
            INNER JOIN parametre ON praticien.pRegion=parametre.pIndice
            INNER JOIN typeparametre ON parametre.pType=typeparametre.tpId
            WHERE parametre.pType='region' AND pRegion='$regionUtilisateur'
            ORDER BY pNum;";
    $resultat = $dbh->query($sql);       // Execution de la requete
    if ($resultat === false) {
        erreurSQL("Pb lors de la recherche des clients.", $sql, $dbh);
    }
    return $resultat;
}

/**
 * Recherche de toutes les familles de médicaments
 * @param type $dbh
 * @return type jeu d'enregistrements
 */
function rechercherLesFamillesMedicament($dbh) {
    $sql = "SELECT fCode,fLibelle 
            FROM famille 
            ORDER BY fLibelle ASC;";
    $resultat = $dbh->query($sql);       // Execution de la requete
    if ($resultat === false) {
        erreurSQL("Pb lors de la recherche des clients.", $sql, $dbh);
    }
    return $resultat;
}

/**
 * Recherche de tous les médicaments
 * @param type $dbh
 * @return type jeu d'enregistrements
 */
function rechercherLesMedicament($dbh,$famille) {
    $sql = "SELECT mDepotLegal, mNomCommercial 
            FROM medicament 
            INNER JOIN famille ON medicament.mFamille=famille.fCode
            WHERE mFamille = '$famille'
            ORDER BY mNomCommercial ASC;";
    $resultat = $dbh->query($sql);       // Execution de la requete
    if ($resultat === false) {
        erreurSQL("Pb lors de la recherche des clients.", $sql, $dbh);
    }
    return $resultat;
}





/**
 * Recherche une visite à partir de son identifiant.
 * @param type $dbh         chaine de connexion
 * @param type $idVisite    id de la visite recherché, entier
 * @return type             informations de la visite, ou false si la visite n'existe pas.
 */
function rechercherUneVisite($dbh, $idUtil,$idVisite) {
    $sql = "SELECT visite.*, pLibelle as vMotifLibelle,praticien.pNum as IdPraticien, CONCAT(praticien.pNom, ' ', praticien.pPrenom ,' , ',praticien.pRue, ' (', praticien.pVille, ')') AS praticienAdresse, medicament1.mNomCommercial AS vMedicament1, famille1.fLibelle AS vFamille1, medicament2.mNomCommercial AS vMedicament2, famille2.fLibelle AS vFamille2 
            FROM visite 
            INNER JOIN medicament AS medicament1 ON visite.vMedicament1 = medicament1.mDepotLegal 
            LEFT JOIN medicament AS medicament2 ON visite.vMedicament2 = medicament2.mDepotLegal 
            INNER JOIN famille AS famille1 ON medicament1.mFamille = famille1.fCode 
            LEFT JOIN famille AS famille2 ON medicament2.mFamille = famille2.fCode 
            INNER JOIN praticien ON visite.pNum = praticien.pNum 
            INNER JOIN parametre ON visite.vMotif = parametre.pIndice 
            WHERE visite.uId = '$idUtil' AND parametre.pType = 'motifVi' AND visite.vNum='$idVisite';";
    $resultat = $dbh->query($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la recherche de la visite. $idVisite", $sql, $dbh);
    }
    return $resultat->fetch();
}








/**
 * Création de la visite dont les données sont passées en paramètres
 * @param type $dbh         chaine de connexion
 * @param type $idClient    id du client (entier)
 * @param type $idUtil      id de l'utilisateur (entier)     *
 * @param type $dateVisite  date de la visite (date)
 * @param type $hreVisite   heure de la visite (time)     *
 * @param type $remarque    remarque (chaine de caractères)
 */
 function creerVisite($dbh, $idUtil, $idPraticien, $remarque, $motifVisite, $medicament1, $medicament2, $confiance, $dateHeureVisite)
 {
    // Obtenir le max de vNum de l'utilisateur + 1
    $sql = "SELECT MAX(vNum) AS max_vNum FROM visite WHERE uId = '$idUtil'";
    $resultat = $dbh->query($sql);
    $ligne = $resultat->fetch();
    $vNum = $ligne['max_vNum'] + 1;

    // Préparer la date et l'heure de visite
    $dateHeureVisiteFormat = date("Y-m-d H:i:s", strtotime($dateHeureVisite));

    // Insérer la visite dans la base de données sans la valeur de vMedicament2
    $sql = "INSERT INTO visite (vNum, uId, pNum, CRDate, vRapport, vMotif, vMedicament1, vMedicament2, vCoefConfiance, CRDateMaj, vDate) 
    VALUES ($vNum, '$idUtil', $idPraticien, NOW(), '$remarque', '$motifVisite', '$medicament1', '$medicament2', $confiance, NOW(), '$dateHeureVisiteFormat')";

    $resultatInsertion = $dbh->exec($sql);
    if ($resultatInsertion === false) {
        erreurSQL("Pb lors de l'ajout d'une visite.", $sql, $dbh);
    }

    // Retourner à la fois vNum et le résultat de l'insertion
    return true;
 }
 
 




function supprimerVisite($dbh, $idVisite, $numVisite) {
    $sql = "DELETE FROM `echantillonoffert` WHERE uId='$idUtil' and vNum = '$numVisite'";
    $resultat = $dbh->exec($sql);

    $sql = "DELETE FROM visite WHERE visite.uId='$idVisite' AND visite.vNum='$numVisite';";
    $resultat = $dbh->exec($sql);
    if ($resultat === false) {
    erreurSQL("Pb lors de la suppression de la visite.", $dbh->error);
    }
    
    return $resultat;
}





function modifierVisite($dbh, $vNum, $IdPraticien, $idUtil, $remarque, $motif, $confiance) {
    $sql = "UPDATE visite 
            SET pNum='$IdPraticien', vCoefConfiance=$confiance ,CRDateMaj=NOW(), vRapport='$remarque', vMotif='$motif' 
            WHERE vNum='$vNum' AND visite.uId='$idUtil';";
    $resultat = $dbh->exec($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la modification de la visite.", $sql, $dbh);
    }
    return true;
}


/**
 * Recherche des client d'un utilisateur
 * @param type $dbh chaine de connexion
 * @param type $idUtil entier, id de l'utilisateur
 * @return type jeu d'enregistrements
 */

function rechercherLesVisitesDuCommercial($dbh, $idUtil, $page, $sort) {
    $sql = "SELECT visite.uId, vNum, pNom, pPrenom, DATE_FORMAT(vDate, '%d-%m-%y %H:%i') as vDate, DATE_FORMAT(CRDate, '%d-%m-%y') as CRDate, DATE_FORMAT(CRDateMaj, '%d-%m-%y') as CRDateMaj, vRapport, parametre2.pLibelle as motif, 
    COALESCE(medicament1.mNomCommercial, medicament2.mNomCommercial) as mNomCommercial,
    medicament1.mNomCommercial as vMedicament1, medicament2.mNomCommercial as vMedicament2, vCoefConfiance 
    FROM visite 
    INNER JOIN praticien ON visite.pNum = praticien.pNum
    INNER JOIN utilisateur ON visite.uId = utilisateur.uId
    INNER JOIN parametre as parametre1 ON utilisateur.uStatut = parametre1.pIndice
    INNER JOIN typeparametre ON parametre1.pType = typeparametre.tpId
    INNER JOIN parametre as parametre2 ON visite.vMotif = parametre2.pIndice
    LEFT JOIN medicament as medicament1 ON visite.vMedicament1 = medicament1.mDepotLegal
    LEFT JOIN medicament as medicament2 ON visite.vMedicament2 = medicament2.mDepotLegal
    WHERE visite.uId = '$idUtil' AND parametre1.pType = 'statUti' AND parametre2.pType = 'motifVi'
    ORDER BY vDate $sort
    LIMIT 10 OFFSET $page;";

    $resultat = $dbh->query($sql); // Execution de la requete
    if ($resultat === false) {
        erreurSQL("Pb lors de la recherche des clients.", $sql, $dbh);
    }
    return $resultat;
}





function rechercherUnUtilisateur($dbh,$id) {
    $sql = "SELECT uNom,uPrenom,uAdresse,uCp,uVille, parametre1.pLibelle as uSecteur , parametre2.pLibelle as uLabo , parametre3.pLibelle as uRegion 
            FROM utilisateur 
            INNER JOIN parametre as parametre1 ON utilisateur.uSecteur=parametre1.pIndice
            INNER JOIN parametre as parametre2 ON utilisateur.uLabo=parametre2.pIndice
            INNER JOIN parametre as parametre3 ON utilisateur.uRegion=parametre3.pIndice
            INNER JOIN typeparametre ON parametre1.pType=typeparametre.tpId
            WHERE utilisateur.uId = '$id' AND parametre1.pType='secteur' AND parametre2.pType='labo' AND parametre3.pType='region';";
    $resultat = $dbh->query($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la recherche de l'utilisateur . $id", $sql, $dbh);
    }
    return $resultat->fetch();
}

function modifierUtilisateur($dbh, $id, $mail) {
    $sql = "UPDATE utilisateur SET uMail='$mail' WHERE uId='$id';";
    $resultat = $dbh->exec($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la modification de l'utilisateur.", $sql, $dbh);
    }
    return true;
}

function nombreDeVisites($dbh,$id)
{
    $sql = "SELECT COUNT(*)
    FROM visite 
    INNER JOIN utilisateur ON visite.uId=utilisateur.uId
    WHERE visite.uId = '$id';";
    $resultat = $dbh->query($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la modification de l'utilisateur.", $sql, $dbh);
    }
    $row = $resultat->fetch(PDO::FETCH_NUM);
    return $row[0];
}



function recupererStatut($dbh,$id)
{
$sql = "SELECT pLibelle 
        FROM utilisateur 
        INNER JOIN parametre ON utilisateur.uStatut =parametre.pIndice 
        INNER JOIN typeparametre ON parametre.pType=typeparametre.tpId 
        WHERE utilisateur.uId = '$id' AND pType='statUti';";
    $resultat = $dbh->query($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la modification de l'utilisateur.", $sql, $dbh);
    }
    $row = $resultat->fetch(PDO::FETCH_NUM);
    return $row[0];
}




function motifPlusSouvent($dbh,$id)
{
    $sql = "SELECT vMotif , COUNT(vMotif) as count 
            FROM visite 
            WHERE uID = '$id' 
            GROUP BY vMotif 
            HAVING COUNT(vMotif) = 
                (SELECT MAX(count) 
                 FROM (SELECT COUNT(vMotif) as count 
                       FROM visite 
                       WHERE uID = '$id' 
                       GROUP BY vMotif) as sousRequete);";

$resultat = $dbh->query($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la modification de l'utilisateur.", $sql, $dbh);
    }
    $row = $resultat->fetch(PDO::FETCH_NUM);
    return $row[0];
}

function motifPlusSouventSuite($dbh,$vMotif)
{
    $sql = "SELECT parametre.pLibelle
            FROM visite 
            INNER JOIN parametre ON visite.vMotif=parametre.pIndice
            INNER JOIN typeparametre ON parametre.pType=typeparametre.tpId
            WHERE parametre.pIndice = '$vMotif' AND pType='motifVi' ";

$resultat = $dbh->query($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la modification de l'utilisateur.", $sql, $dbh);
    }
    $row = $resultat->fetch(PDO::FETCH_NUM);
    return $row[0];
}





function rechercherLesMotifs($dbh) {
    $sql = "SELECT pIndice, pLibelle 
            FROM parametre 
            WHERE parametre.pType = 'motifVi'";
    $resultat = $dbh->query($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la recherche des motifs", $sql, $dbh);
    }
    return $resultat->fetchAll();
}





function rechercherRegionUtilisateur($dbh,$id)
{
    $sql = "SELECT uRegion 
    FROM utilisateur 
    WHERE utilisateur.uId = '$id';";
    $resultat = $dbh->query($sql);
    if ($resultat === false) {
    erreurSQL("Pb lors de la recherche de l'utilisateur . $id", $sql, $dbh);
    }
return $resultat->fetch();
}




function nombreEchantillons($dbh,$id)
{
    $sql = "SELECT ROUND(AVG(OFF_QTE))
    FROM echantillonoffert 
    INNER JOIN utilisateur ON echantillonoffert.uId=utilisateur.uId
    WHERE echantillonoffert.uId = '$id';";
    $resultat = $dbh->query($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la modification de l'utilisateur.", $sql, $dbh);
    }
    $row = $resultat->fetch(PDO::FETCH_NUM);
    return $row[0];
}

function nombreEchantillonsParVisite($dbh,$id)
{
    $sql = "SELECT ROUND(AVG(subquery.count_distinct_mDepotLegal)) AS moyenne_count 
            FROM ( SELECT vNum, COUNT(DISTINCT mDepotLegal) AS count_distinct_mDepotLegal 
                   FROM echantillonoffert 
                   INNER JOIN utilisateur ON echantillonoffert.uId = utilisateur.uId 
                   WHERE echantillonoffert.uId = '$id' 
                   GROUP BY vNum ) AS subquery;;";
    $resultat = $dbh->query($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la modification de l'utilisateur.", $sql, $dbh);
    }
    $row = $resultat->fetch(PDO::FETCH_NUM);
    return $row[0];
}





function tpsMoy($dbh,$id)
{
    $sql = "SELECT ROUND(AVG(DATEDIFF(CRDate,vDate ))) 
            FROM `visite` 
            WHERE uId='$id';";
    $resultat = $dbh->query($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la modification de l'utilisateur.", $sql, $dbh);
    }
    $row = $resultat->fetch(PDO::FETCH_NUM);
    return $row[0];
}




function coefConfiance($dbh,$id)
{
    $sql = "SELECT ROUND(AVG(vCoefConfiance))
            FROM `visite` 
            WHERE uId='$id';";
    $resultat = $dbh->query($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la modification de l'utilisateur.", $sql, $dbh);
    }
    $row = $resultat->fetch(PDO::FETCH_NUM);
    return $row[0];
}


function maxvNumUtil($dbh,$idUtil)
{
    $sql = "SELECT MAX(visite.vNum) 
            FROM `visite` 
            WHERE uId='$idUtil';";
    $resultat = $dbh->query($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la modification de l'utilisateur.", $sql, $dbh);
    }
    $row = $resultat->fetch(PDO::FETCH_NUM);
    return $row[0];
}


function ajoutEchantillon($dbh, $idUtil,$vNum, $medicament, $nombre) {
    $sql = "INSERT INTO echantillonoffert (uId, vNum, mDepotLegal, OFF_QTE)
            VALUES ('$idUtil', '$vNum', '$medicament', '$nombre');";
    $resultat = $dbh->exec($sql);
    if ($resultat === false) {
        erreurSQL("Pb lors de la modification de l'utilisateur.", $sql, $dbh);
    }
    return true;
}

function AfficheEchantillon($dbh, $idUtil, $vNum) {
    $sql = "SELECT medicament.mNomCommercial, famille.fLibelle, OFF_QTE
            FROM `echantillonoffert`
            INNER JOIN medicament ON echantillonoffert.mDepotLegal = medicament.mDepotLegal
            INNER JOIN famille ON medicament.mFamille = famille.fCode
            WHERE uId = '$idUtil' AND vNum = '$vNum';";
    $resultat = $dbh->query($sql);
    
    if ($resultat === false) {
        erreurSQL("Pb lors de la modification de l'utilisateur.", $sql, $dbh);
    }
    return $resultat->fetchAll();
}